// Rad_Text.js | Radnen 2008 //

// Internal textbox object //
var Textbox = {speaker: "",lines: ["", ""],style: new Style(),delay: 30,lineHeight: 12,height: 24,showName: true}

function SetTextBoxStyle(style)
{
	Textbox.style = style;
	Textbox.lineHeight = style.font.getHeight();
}

function ShowTextBoxName(value)
{
	Textbox.showName = value;
}

function SetTextBoxDelay(delay)
{
	Textbox.delay = delay;
}

function DrawBox()
{
	var b = Textbox.style.borderSize;
	if (IsMapEngineRunning()) RenderMap();
	else Textbox.bg.blit(0, 0);
	Textbox.style.window.drawWindow(b, SH-Textbox.height-b, SW-b*2, Textbox.height);
	if (Textbox.showName)
	{
		Textbox.style.window.drawWindow(b, SH-Textbox.height-Textbox.lineHeight-b*2, Textbox.style.font.getStringWidth(Textbox.speaker + ": "), Textbox.lineHeight);
		Textbox.style.drawText(b, SH-Textbox.height-Textbox.lineHeight-b*2, Textbox.speaker + ":");
	}
}

function DrawLines()
{
	var b = Textbox.style.borderSize;
	while (!IsKeyPressed(KEY_ENTER) && !IsMouseButtonPressed(MOUSE_LEFT))
	{
		// Phase 1: Draw BG
		DrawBox();
		// Phase 2: Print lines //
		for (var l = 0; l < Textbox.lines.length; ++l)
		{
			Textbox.style.drawText(b+4, SH-Textbox.height-b+l*Textbox.lineHeight, Textbox.lines[l]);
		}
		// Phase 3: Draw blinking next arrow //
		BlinkImg(Textbox.style.downArrow, SW/2-Textbox.style.downArrow.width/2, SH-Textbox.style.downArrow.height);
		// Phase 4: Show lines //
		FlipScreen();
	}
}

function TextSpeedUp(num)
{
	return IsKeyPressed(KEY_CTRL);
}

function ShowText(speaker) // extra arguments become lines //
{
	Textbox.lines = []; // Clear the lines array //
	Textbox.speaker = speaker;
	if (Textbox.showName)
		for (var i = 1; i < arguments.length; ++i) Textbox.lines[i-1] = arguments[i];
	else
		for (var i = 0; i < arguments.length; ++i) Textbox.lines[i] = arguments[i];
	Textbox.bg = GrabImage(0, 0, SW, SH);
	Textbox.height = Textbox.lines.length * Textbox.lineHeight;
	var b = Textbox.style.borderSize;
	
	for (var l = 0; l < Textbox.lines.length; ++l)
	{
		for (var i = 0; i < Textbox.lines[l].length; ++i)
		{
			// Phase 1: Skip on Keypress //
			if (TextSpeedUp()) { Delay(Textbox.delay); break; }
			// Phase 2: Draw BG
			DrawBox();
			// Phase 3: Draw previous lines //
			for (var a = 0; a < l; ++a)
			{
				Textbox.style.drawText(b+4, SH-Textbox.height-b+a*Textbox.lineHeight, Textbox.lines[a]);
			}
			// Phase 4: Print next line //
			Textbox.style.drawText(b+4, SH-Textbox.height-b+l*Textbox.lineHeight, Textbox.lines[l].substr(0, i));
			// Phase 5: Show lines //
			FlipScreen();
			// Phase 6: A timed delay //
			Delay(Textbox.delay);
		}
	}
	DrawLines();
	Textbox.bg.blit(0, 0);
}

function AppendText(newline, add)
{
	Textbox.lines.push(newline);
	if (!add) Textbox.lines.shift();
	Textbox.height = Textbox.lines.length*Textbox.lineHeight;
	var b = Textbox.style.borderSize;
	
	for (var i = 0; i < Textbox.lines[Textbox.lines.length-1].length; ++i)
	{
		if (TextSpeedUp()) break;
		DrawBox();
		for (var l = 0; l < Textbox.lines.length; ++l)
		{
			for (var a = 0; a < l; ++a)
			{
				Textbox.style.drawText(b+4, SH-Textbox.height-b+a*Textbox.lineHeight, Textbox.lines[a]);
			}
		}		
		Textbox.style.drawText(b+4, SH-Textbox.lineHeight-b, Textbox.lines[Textbox.lines.length-1].substr(0, i));
		FlipScreen();
		Delay(Textbox.delay);
	}
	DrawLines();
	Textbox.bg.blit(0, 0);
}

function DrawCenteredText(width, height, text, forcebg)
{
	Textbox.line1 = text;
	Textbox.bg = GrabImage(0, 0, SW, SH);
	
	for (var i = 0; i < Textbox.line1.length; ++i)
	{
		if (TextSpeedUp()) break;
		if (IsMapEngineRunning()) RenderMap();
		else Textbox.bg.blit(0, 0);
		if (forcebg) Textbox.bg.blit(0, 0);
		Textbox.style.drawText(width/2-Textbox.style.font.getStringWidth(text)/2, height, Textbox.line1.substr(0, i));
		FlipScreen();
		Delay(Textbox.delay);
	}
	
	while (!IsKeyPressed(KEY_ENTER) && !IsMouseButtonPressed(MOUSE_LEFT))
	{
		if (IsMapEngineRunning()) RenderMap();
		else Textbox.bg.blit(0, 0);
		if (forcebg) Textbox.bg.blit(0, 0);
		Textbox.style.drawText(width/2-Textbox.style.font.getStringWidth(text)/2, height, Textbox.line1);
		BlinkImg(Textbox.style.downArrow, width/2-Textbox.style.downArrow.width/2, height + Textbox.lineHeight);
		FlipScreen();
	}
	
	ClearKeyQueue();
	Textbox.bg.blit(0, 0);
}